* Title: 	table3.do
* Version: 	23 May 2018
* Purpose: 	Regress ASEC Bartik shock on joblessness and house price index 
*			(state level), regress ACS Bartik shock on joblessness (PUMA level)


*******************************************************************************
* (0) Start of file
*******************************************************************************

capture log close
log using output/tables/log/table3, text replace
set more off
clear all
macro drop _all


*******************************************************************************
* (1) Load data (ASEC)
*******************************************************************************

use year statefip UnempB PrimeMaleD wtsupp using dta/asec_clean, clear

* Keep only prime-age men
keep if PrimeMaleD == 1

* Keep only continental 48 states (excluding District of Columbia)
drop if (statefip == 02 | statefip == 11 | statefip == 15 | statefip>56)

* Keep only 1977 on
keep if year >= 1977

*******************************************************************************
* (2) Create annual change data in joblessness (ASEC)
*******************************************************************************

collapse (sum) Total = PrimeMaleD Jobless = UnempB [pw = wtsupp], by(statefip year)

gen double Jobless_Rate = Jobless / Total

keep Jobless_Rate statefip year
reshape wide Jobless_Rate, i(statefip) j(year)
gen double Jobless_Rate_1977 = Jobless_Rate1977
reshape long Jobless_Rate, i(statefip) j(year)

xtset statefip year
gen Jobless_Delta = Jobless_Rate - L.Jobless_Rate


*******************************************************************************
* (3) Merge with Bartik shocks and house price index (ASEC)
*******************************************************************************

merge 1:1 year statefip using dta/bartik_asec, keep(matched) nogen
merge 1:1 year statefip using dta/housing, keep(master matched) nogen

* Keep years with Bartik shock
keep if year >= 1978

tempfile state
save `state'


*******************************************************************************
* (4) Load data (ACS)
*******************************************************************************

use year statefip cpuma0010 UnempB PrimeMaleD perwt using dta/acs_clean, clear

* Keep only prime-age men
keep if PrimeMaleD == 1

* Keep only continental 48 states (excluding District of Columbia)
drop if (statefip == 02 | statefip == 11 | statefip == 15 | statefip>56)


*******************************************************************************
* (5) Create annual change data in joblessness (ACS)
*******************************************************************************

collapse (sum) Total = PrimeMaleD Jobless = UnempB [pw = perwt], by(cpuma0010 statefip year)

gen double Jobless_Rate = Jobless / Total

keep Jobless_Rate cpuma0010 statefip year
reshape wide Jobless_Rate, i(cpuma0010 statefip) j(year)
gen double Jobless_Rate_2005 = Jobless_Rate2005
reshape long Jobless_Rate, i(cpuma0010 statefip) j(year)

xtset cpuma0010 year
gen Jobless_Delta = Jobless_Rate - L.Jobless_Rate


*******************************************************************************
* (6) Merge with Bartik shocks (ACS)
*******************************************************************************

merge 1:1 year cpuma0010 using dta/bartik_acs, assert(matched) nogen

* Keep years with Bartik shock
keep if year >= 2006

tempfile puma
save `puma'


*******************************************************************************
* (7) Regressions
*******************************************************************************

use `state', clear
save output/tables/dta/table3a_state.dta, replace

* Column 1: Change in state not working rate - Bartik shock with historical jobless rate and time trend
reg Jobless_Delta Bartik i.statefip year, vce(cluster statefip)

* Column 2: Change in state not working rate - Interactions with historical jobless rate and time trend
reg Jobless_Delta Bartik c.Bartik#c.Jobless_Rate_1977 i.statefip year, vce(cluster statefip)

* Column 3: Change in state not working rate - Bartik shock with historical jobless rate and year fixed effects
reg Jobless_Delta Bartik i.statefip i.year, vce(cluster statefip)

* Column 4: Change in state not working rate - Interactions including year fixed effects
reg Jobless_Delta Bartik c.Bartik#c.Jobless_Rate_1977 i.statefip i.year, vce(cluster statefip)

* Column 5: House price index - Bartik shock with historical jobless rate
reg HouseIndex_Delta Bartik  i.statefip i.year, vce(cluster statefip)

* Column 6: House price index - Interactions including year fixed effects
reg HouseIndex_Delta Bartik c.Bartik#c.Jobless_Rate_1977 i.statefip i.year, vce(cluster statefip)


use `puma', clear
save output/tables/dta/table3b_puma.dta, replace

* Column 7: Change in PUMA not working rate - Bartik shock with historical jobless rate and year fixed effects
reg Jobless_Delta Bartik Jobless_Rate_2005 i.year i.statefip, vce(cluster statefip)

* Column 8: Change in PUMA not working rate - Interactions including year fixed effects
reg Jobless_Delta c.Bartik##c.Jobless_Rate_2005 i.year i.statefip, vce(cluster statefip)


*******************************************************************************
* (5) End of file
*******************************************************************************

log close
